#include <Potentiometer.h>                       // Ανοιγμα της βιβλιοθήκης που επικαλείται παρακάτω ο κώδικας

int potPort = A0;                                // Δήλωση της θύρας όπου συνδέεται του ποτενσιόμετρο (επιλέγουμε αναλογική θύρα για τη σύνδεση του ποτενσιομέτρου στο Arduino)


float potMin = -10.00;                           // Δήλωση μεταβλητής potMin και της τιμής της. Είναι η ελάχιστη τιμή που μπορεί να πάρει το ποτενσιόμετρο
float potMax = 10.00;                            // Δήλωση μεταβλητής potMax και της τιμής της. Είναι η μέγιστη τιμή που μπορεί να πάρει το ποτενσιόμετρο
float calibration=0.00;                          // Δήλωση μεταβλητής όπου θα αποθηκευτεί κατόπιν η τιμή του ποτενσιόμετρου

Potentiometer myPot(potPort, potMin, potMax);    // Έναρξη του ποτενσιόμετρου 

void setup() 
{
  Serial.begin(9600);                            // Εκκίνηση της Σειριακής Θύρας με ταχύτητα 9600
}

void loop() 
{
  calibration = myPot.read();                   // Ανάγνωση της τιμής του ποτενσιόμετρου  (θα είναι μεταξύ της μέγιστης potMax και ελάχιστης τιμής potMin που ορίσαμε παραπάνω στον κώδικα)
  Serial.print("Τιμή του ποτενσιόμετρου= ");    // Eμφάνιση κειμένου στο παράθυρο σειρακής (Tools/Serial Monitor)
  Serial.println(calibration);                  // Εμφάνιση της τιμής του ποτενσιόμετρου
  delay(1000);                                  // Καθυστέρηση κατά 1s για σταθερότητα αναγνώσεων
}
